/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.compat;

import com.iafenvoy.jupiter.config.ConfigSide;
import com.iafenvoy.jupiter.config.ConfigSource;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.screen.ConfigSelectScreen;
import com.iafenvoy.jupiter.util.TextFormatter;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public final class ExtraConfigManager {
    private static final Map<ConfigSource, Supplier<Map<String, EnumMap<ConfigSide, AbstractConfigContainer>>>> SCANNERS = new LinkedHashMap<ConfigSource, Supplier<Map<String, EnumMap<ConfigSide, AbstractConfigContainer>>>>();
    private static final Map<ConfigSource, Map<String, EnumMap<ConfigSide, AbstractConfigContainer>>> CONFIGS = new LinkedHashMap<ConfigSource, Map<String, EnumMap<ConfigSide, AbstractConfigContainer>>>();
    private static final List<Runnable> CALLBACKS = new LinkedList<Runnable>();

    public static void registerScanner(ConfigSource source, Supplier<Map<String, EnumMap<ConfigSide, AbstractConfigContainer>>> scanner) {
        SCANNERS.put(source, scanner);
    }

    public static void scanConfigs() {
        for (Map.Entry<ConfigSource, Supplier<Map<String, EnumMap<ConfigSide, AbstractConfigContainer>>>> entry : SCANNERS.entrySet()) {
            CONFIGS.put(entry.getKey(), entry.getValue().get());
        }
        CALLBACKS.forEach(Runnable::run);
    }

    public static Set<String> getProvidedMods() {
        return CONFIGS.values().stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Optional<EnumMap<ConfigSide, AbstractConfigContainer>> find(String modId) {
        return CONFIGS.values().stream().map(x -> (EnumMap)x.get(modId)).filter(Objects::nonNull).findFirst();
    }

    public static Function<class_437, ConfigSelectScreen> getScreen(String modId) {
        return parent -> {
            Optional<EnumMap<ConfigSide, AbstractConfigContainer>> optional = ExtraConfigManager.find(modId);
            if (optional.isEmpty()) {
                return null;
            }
            ConfigSelectScreen.Builder builder = ConfigSelectScreen.builder((class_2561)TextUtil.literal(TextFormatter.formatToTitleCase(modId + "_configs")), parent).displayCommon();
            for (Map.Entry<ConfigSide, AbstractConfigContainer> entry : optional.get().entrySet()) {
                AbstractConfigContainer container = entry.getValue();
                switch (entry.getKey()) {
                    case CLIENT: {
                        builder.client(container);
                        break;
                    }
                    case COMMON: {
                        builder.common(container);
                        break;
                    }
                    case SERVER: {
                        builder.server(container);
                    }
                }
            }
            return builder.build();
        };
    }

    public static void registerScanCallback(Runnable callback) {
        CALLBACKS.add(callback);
    }
}

